// // // // // // // // // // // // // // // // // // // //
//	
//	Simple Reflex Agent
//	
//	created Apr/14/98 by Andreas Warnke
//	last mod Apr/21/98 by Andreas Warnke
//	
//	This class gets the Sensor Data
//	and decides how to act.
//



// // // // // // // // // // // // // // // // // // // //
//	
//	#pragma once
//

#ifndef SimpleReflexAgent_h_
#define SimpleReflexAgent_h_



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "ConnectionData.h"
#include "Sensor.h"
#include "Effector.h"
#include "Map.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	SimpleReflexAgent Declaration
//

class SimpleReflexAgent : public Sensor, public Effector, protected Map
{
private:
	//	Get the FieldTypes of the 6 fields next to inX, inY:
	static void GetEnvironment (
		int inX,
		int inY,
		BMessage * inMessage,
		unsigned int & outFieldAt1,
		unsigned int & outFieldAt3,
		unsigned int & outFieldAt5,
		unsigned int & outFieldAt7,
		unsigned int & outFieldAt9,
		unsigned int & outFieldAt11 );
		
	//	Look for Enemies:
	bool LookForEnemies (
		int inX,
		int inY,
		BMessage * inMessage,
		int & outDir );
		
	//	special StatusMessageReceived - Method:
	virtual void StatusMessageReceived ( BMessage * inMessage );
	
protected:
	
public:
	//	Constructor:
	SimpleReflexAgent ();
	
	//	Destructor:
	virtual ~SimpleReflexAgent ();
	
	//	MessageReceived:
	virtual void MessageReceived ( BMessage * inMessage );
};



#endif



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //